/*
 * WieWarm Widget by inbox@brotherli.ch
 * Temparature data kindly provided by www.wiewarm.ch
 * Copyright 2005-2010 by Thomas Bruederli, all rights reserved.
 *
 * Version:	 1.1
 * Released: 2010-04-03
 *
*/

// settings
var refresh_time = 60; // minutes
var xml_feed_url = "http://www.wiewarm.ch/xmlData.php";
var widget_version = "1.1";
var widget_width = 315;
var widget_height = 90;
var widget_back_height = 172;
var widget_footer_offset = 22;
var menu_left = 25;
var menu_top = 65;


// global vars
var timer_interval = null;
var xml_feed_data = null;
var selected_location = null;
var last_data_load = null;
var last_version_check = 0;
var http_request = new XMLHttpRequest();
var version_check_request;
var backside = false;



function init()
{
	if (window.widget) {
		selected_location = widget.preferenceForKey(createkey("locationID"));
		var lvc = widget.preferenceForKey(createkey("versionCheckDate"));
		if (lvc) last_version_check = parseInt(lvc);
	}

	if (!selected_location) {
		show_backside(event);
		return;
	};

	show_bath_info();
	timer_interval = window.setInterval('show_bath_info();', refresh_time*60000);
}


function onshow()
{
	if (!backside) {
		show_bath_info();
		timer_interval = window.setInterval('show_bath_info();', refresh_time*60000);
	}
	check_version();
}


function onhide() {
	if (timer_interval)
		window.clearTimeout(timer_interval); 
}


function onremove()
{
	if (window.widget) {
		widget.setPreferenceForKey(null, createkey("locationID"));
		widget.setPreferenceForKey(null, createkey("versionCheckDate"));
	}
}


function show_backside(event)
{
	onhide();

	var front = document.getElementById('front-panel');
	var back = document.getElementById('reverse-side');
	var flip = document.getElementById('fliprollie');

	backside = true;
	adjust_window();

	if (window.widget)
		widget.prepareForTransition('ToBack');

	var bath_node = get_bath_node(selected_location);
	if (bath_node) {
		var bathname = bath_node.getAttribute('name') + ', ' + bath_node.getAttribute('ort');
		document.getElementById('search-input').value = bathname;
	}

	front.style.display = 'none';
	flip.style.display = 'none';
	back.style.display = 'block';

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}



function done_clicked(event)
{
	var front = document.getElementById("front-panel");
	var back = document.getElementById("reverse-side");
	
	if (window.widget) {
		widget.prepareForTransition("ToFront");
		widget.setPreferenceForKey(selected_location, createkey("locationID"));
	}

	front.style.display = 'block';
	back.style.display = 'none';

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
		
	backside = false;

	adjust_window();
	onshow();
}



function createkey(key)
{
	return widget.identifier + "-" + key;
}


function get_localized_string(key)
{
	try {
		var ret = localized_strings[key];
		if (typeof(ret) == 'undefined')
			ret = key;
		return ret;
	}
	catch (ex) {}

	return key;
}


function show_bath_info()
{
	var now = new Date().getTime();
	var refresh = (!last_data_load || now > last_data_load+refresh_time*50000);
	
	if (!xml_feed_data || refresh) {
		load_data();
		return;
	}
	else if (xml_feed_data && selected_location)
		build_bath_info();
	else
		reset_bath_info();
}


function show_bath_selection()
{
	var input = document.getElementById('search-input');
	var status = document.getElementById('searchmsg');
	var search = input.value;
	var reload = true;

	// clear status display
	status.innerHTML = '';
	selected_location = null;
	
	if (!String(search).length)
		return;

	// check if we have the complete list loaded
	if (xml_feed_data) {
		var bath_nodes = xml_feed_data.getElementsByTagName('BAD');
		reload = bath_nodes.length>1 ? false : true;
	}

	if (reload) {
		load_data(true);
		return;
	}

	var search_results = search_bath(search);

	// no bath found
	if (search_results === false || !search_results.length) {
		//input.value = '';
		input.focus();

		if (status) {
			status.innerHTML = get_localized_string('No locations found');
			status.style.display = 'block';
		}
	}
	// search returned one result
	else if (search_results.length==1) {
		selected_location = search_results[0].id;
		input.value = search_results[0].name;
	}
	else {
		if (!window.widget)
			return;

		var menu = widget.createMenu();
		for (var n=0; n<search_results.length; n++)
			menu.addMenuItem(search_results[n].name);

		var selected_item = menu.popup(menu_left, menu_top);
		if (selected_item >= 0) {
			selected_location = search_results[selected_item].id;
			input.value = search_results[selected_item].name;
		}
		else
			selected_location = null;
	}
}


function change_search()
{
	show_bath_selection();
}


function load_data(show_all)
{
	show_load_status(true);

	var url = xml_feed_url+'?widgetVersion='+widget_version;
		
	// send location id
	if (!show_all && selected_location)
		url += '&id='+selected_location;
		
	http_request.onreadystatechange = http_readystate_change;
	http_request.setRequestHeader('Accept-Encoding', 'gzip');
	http_request.open('GET', url+'&ts='+(new Date().getTime()));
	http_request.send(null);
	http_request.busy = true;
}


function http_readystate_change()
{
	if (http_request && http_request.readyState == 4) {

		xml_feed_data = http_request.responseXML;
		show_load_status(false);
		http_request.busy = false;
		last_data_load = new Date().getTime();
		
		if (xml_feed_data) {
			if (backside)
				show_bath_selection();
			else
				build_bath_info();
		}
		else {
			reset_bath_info();
			
			var errormsg = get_localized_string('Server unavailable');
			
			if (http_request.status == 200 && !xml_feed_data)
				errormsg = get_localized_string('Failed to load data');
			
			if (backside)
				show_load_status(true, errormsg);
			else {
				document.getElementById('screen').innerHTML = '<div class="errormsg">'+errormsg+'</div>';
				resize_body();
			}
		}
	}
}



function search_bath(search)
{
	if (!xml_feed_data || !String(search).length)
		return false;
	
	var bath_nodes = xml_feed_data.getElementsByTagName('BAD');
	var results = new Array();
	var node, zip, name, canton;

	// define what to search
	if (search.match(/^([a-z]{2})$/i))
		canton = String(RegExp.$1).toUpperCase();

	if (search.match(/^[0-9]+$/))	 // is numeric
		zip = search;
	else
		name = String(search).toLowerCase();

	// split name/place
	if (name && name.indexOf(',')>0)
		name = name.substring(0, name.indexOf(','));

	// loop through all bath nodes	
	for (var n=0; n<bath_nodes.length; n++) {
		node = bath_nodes[n];
		if ((zip!=null && String(node.getAttribute('plz')).indexOf(zip)==0) ||
			 (canton!=null && node.getAttribute('kanton')==canton) ||
			 (name!=null && String(node.getAttribute('name')).toLowerCase().indexOf(name)>=0) ||
			 (name!=null && String(node.getAttribute('ort')).toLowerCase().indexOf(name)>=0))
			results[results.length] = {id:node.getAttribute('id'), name:node.getAttribute('name')+', '+node.getAttribute('ort')};
	}

	return results;
}


function get_bath_node(id)
{
	if (!xml_feed_data)
		return null;
	
	var bath_nodes = xml_feed_data.getElementsByTagName('BAD');
	for (var n=0; n<bath_nodes.length; n++) {
		if (bath_nodes[n].getAttribute('id')==id)
			return bath_nodes[n];
	}
		
	return null;
}


function build_bath_info()
{
	var display = document.getElementById('screen');
	
	if (!display || !xml_feed_data)
		return false;

	var bath_node = get_bath_node(selected_location);
	if (!bath_node) {
		reset_bath_info();
		return;
	}
	
	var table = document.createElement('TABLE');
	var tbody = document.createElement('TBODY');
	table.appendChild(tbody);
	
	var node, row, td, temp, changed, date_str, outdated, id, img;
	var max_temp_ids = new Array();
	var max_temp = 0;
	var now = new Date();
	var count = 0;

	// loop through the nodes to count pools
	for (var n=0; n<bath_node.childNodes.length; n++) {
		node = bath_node.childNodes[n];
		if (node.nodeType==1)
			count++;
	}

	// build table
	for (var n=0; n<bath_node.childNodes.length; n++) {
		node = bath_node.childNodes[n];
		if (node.nodeType != 1)
			continue;

		// get attributes
		id = node.getAttribute('id');
		temp = parseFloat(node.getAttribute('temperatur'));
		changed = new Date();
		if (node.getAttribute('changed'))
			changed.setTime(parseInt(node.getAttribute('changed')) * 1000);
		else
			changed = parse_date(node.getAttribute('geaendert'));
		
		if (temp > max_temp) {
			max_temp = temp;
			max_temp_ids = new Array(String(id));
		}
		else if (temp == max_temp)
			max_temp_ids[max_temp_ids.length] = id;

		outdated = false;
		if (now.getDate() == changed.getDate() && now.getMonth() == changed.getMonth())
			date_str = get_localized_string('Today') + ' ' + format_date(changed, 'h:mm');
		else if (now.getDate() == changed.getDate()+1)
			date_str = get_localized_string('Yesterday')+ ' ' + format_date(changed, 'h:mm');
		else {
			date_str = format_date(changed, 'DD.MM.YYYY');
			outdated = now.getTime() - changed.getTime() > 10 * 86400000;  // outdated = older than 10 days
		}

		row = document.createElement('TR');
		
		// cell for icon
		if (count > 1) {
			td = document.createElement('TD');
			td.setAttribute('id', 'pool'+id);
			td.setAttribute('class', 'icon');
			row.appendChild(td);
		}

		// set name
		td = document.createElement('TD');
		td.setAttribute('class', 'name');
		td.innerHTML = node.getAttribute('name');
		row.appendChild(td);

		// set temparature
		td = document.createElement('TD');
		td.setAttribute('class', 'temperature');
		td.innerHTML = temp+'&deg;';
		row.appendChild(td);

		// set changed date
		td = document.createElement('TD');
		td.setAttribute('class', 'changed' + (outdated ? ' outdated' : ''));
		td.innerHTML = date_str;
		row.appendChild(td);

		// add table row
		tbody.appendChild(row);
	}

	display.innerHTML = '';
	display.appendChild(table);


	// set icon to the warmest pool
	for (var i=0; count>1 && i<max_temp_ids.length; i++) {
		td = document.getElementById('pool'+max_temp_ids[i]);
		img = document.createElement('IMG');
		img.setAttribute('src', 'images/max_icon.png');
		td.appendChild(img);
	}


	// also set location name and max temp to header
	var header = document.getElementById('location');
	var bath_name = bath_node.getAttribute('name');
	var bath_place = bath_node.getAttribute('ort');
	header.innerHTML = bath_name + (bath_name!=bath_place ? ', '+bath_place : '');
	header.onclick = function(){ widget.openURL('http://www.wiewarm.ch/badDetail.php?id='+selected_location); };
	header.style.cursor = 'pointer';

	var temparature = document.getElementById('temperature');
	temperature.innerHTML = Math.round(max_temp);
	temperature.style.visibility = 'inherit';

	var degrees = document.getElementById('degrees');
	degrees.style.visibility = 'inherit';

	// resize widget body
	resize_body();
}


function parse_date(str)
{
	var date = new Date();

	// "25.9.2009"
	if (str.match(/^([0-9]+)\.([0-9]+)\.([0-9]+)$/)) {
		date.setDate(RegExp.$1);
		date.setMonth(parseFloat(RegExp.$2)-1);
		date.setYear(RegExp.$3);
	}
	// "12.4. - 17:00"
	else if (str.match(/^([0-9]+)\.([0-9]+)[\s\-]+([0-9]+)\:([0-9]+)$/)) {
		date.setDate(RegExp.$1);
		date.setMonth(parseFloat(RegExp.$2)-1);
		date.setHours(RegExp.$3);
		date.setMinutes(RegExp.$4);
	}

	return date;
}


// convert a date object into the desired format
function format_date(date, format)
{
	var dtvar = new Array();
	var reg, reg2, reg3;

	if (!window.RegExp)
		return date.toLocaleString();

	dtvar.year = date.getYear();
	dtvar.month = date.getMonth()+1;
	dtvar.day = date.getDate();
	dtvar.weekday = date.getDay();
	dtvar.hours = date.getHours();
	dtvar.minutes = date.getMinutes();
	dtvar.seconds = date.getSeconds();


	// format year
	reg = /.*(YYYY).*/;
	if(reg.test(format))
		dtvar.year = (dtvar.year<1900) ? dtvar.year+1900 : dtvar.year;
	else if(String(dtvar.year).length==4)
		dtvar.year = String(dtvar.year).substring(2,4);
	else if(dtvar.year>100)
		dtvar.year -= 100;
	if(typeof(dtvar.year)=='number' && dtvar.year<10)
		dtvar.year = '0'+dtvar.year;

	// format month
	reg = /.*(M{2}).*/;
	if(reg.test(format) && dtvar.month<10)
		dtvar.month = '0'+dtvar.month;

	// format day
	reg = /.*(D{2}).*/;
	if(dtvar.day<10 && reg.test(format))
		dtvar.day = '0'+dtvar.day;

	// format hours
	reg = /.*(h{2}).*/;
	if(dtvar.hours<10 && reg.test(format))
		dtvar.hours = '0'+dtvar.hours;

	// format minutes
	reg = /.*(m{2}).*/;
	if(dtvar.minutes<10 && reg.test(format))
		dtvar.minutes = '0'+dtvar.minutes;

	// format seconds
	reg = /.*(s{2}).*/;
	if(dtvar.seconds<10 && reg.test(format))
		dtvar.seconds = '0'+dtvar.seconds;


	var subst = format.replace(/([a-z]+)/ig, '#$1#');
	var out = subst.replace(/#[s]+#/, dtvar.seconds);
	out = out.replace(/#[m]+#/, dtvar.minutes);
	out = out.replace(/#[h]+#/, dtvar.hours);
	out = out.replace(/#[Y]+#/, dtvar.year);
	out = out.replace(/#[M]+#/, dtvar.month);
	out = out.replace(/#[D]+#/, dtvar.day);
	out = out.replace(/\s/, '&nbsp;');

	return out;
}


function reset_bath_info()
{
	var body = document.getElementById('content');
	var header = document.getElementById('location');
	var temparature = document.getElementById('temperature');
	var degrees = document.getElementById('degrees');
	var display = document.getElementById('screen'); 
	
	header.innerHTML = '--';
	header.onclick = null;
	header.style.cursor = 'default';

	display.innerHTML = '';
	temperature.innerHTML = '';
	temperature.style.visibility = 'hidden';
	degrees.style.visibility = 'hidden';
	body.style.height = widget_footer_offset+'px';
	
	adjust_window();
}


function resize_body()
{
	var display = document.getElementById('screen'); 
	var body = document.getElementById('content');
	if (display && body) {
		var height = display.offsetHeight;
		body.style.height = (height+widget_footer_offset)+'px';
		
		adjust_window();
	}
}


function adjust_window()
{
	var height = backside ? widget_back_height : widget_height;
	var body = document.getElementById(backside ? 'reverse-side' : 'front-panel');

	if (!backside && body && body.offsetHeight)
		height = body.offsetHeight;

	if (window.widget && height)
		window.resizeTo(widget_width, height);
}


function show_load_status(vis, msg)
{
	var footnote, loading;
	var text = msg ? msg : get_localized_string('Loading data');
	
	if (backside) {
		if (loading = document.getElementById('searchmsg')) {
			loading.innerHTML = text;
			loading.style.display = vis ? 'block' : 'none';
		}
	}
	else {
		if (footnote = document.getElementById('footnote'))
			footnote.style.display = vis ? 'none' : 'block';
		if (loading = document.getElementById('loadingmsg')) {
			loadingmsg.innerHTML = text;
			loading.style.display = vis ? 'block' : 'none';
		}
	}
}


function check_version()
{
	var now = new Date().getTime();
	if (last_version_check < now - 86400) {
		version_check_request = new XMLHttpRequest();
		version_check_request.onreadystatechange = version_check_readystate_change;
		version_check_request.open('GET', 'http://labs.brotherli.ch/wiewarm/version.txt?t='+now);
		version_check_request.send(null);
	}
}


function version_check_readystate_change()
{
	if (window.version_check_request && version_check_request.readyState == 4) {
		var content = version_check_request.responseText.split("\n");
		var info = {};
		for (var i=0; i<content.length; i++) {
			var pair = content[i].split(": ");
			if (pair.length == 2)
				info[pair[0]] = pair[1];
		}
				
		// new version is available
		if (info.Version && info.Version > widget_version) {
			window.alert_action = function() {
				widget.openURL(info.URL);
			};
			show_alert(info.Message ? info.Message : get_localized_string('A new version is available. Install it now?'));
		}
		
		last_version_check = new Date().getTime();
		if (window.widget)
			widget.setPreferenceForKey(String(last_version_check), createkey("versionCheckDate"));
	}
}

function show_alert(msg)
{
	document.getElementById('alerttext').innerHTML = msg;
	document.getElementById('alertbox').style.display = 'block';
}

function alert_clicked_yes()
{
	if (typeof window.alert_action == 'function')
		alert_action();
		
	alert_no_clicked();
}

function alert_clicked_no()
{
	document.getElementById('alertbox').style.display = 'none';
}


// init widget events
if (window.widget) {
	widget.onhide = onhide;
	widget.onshow = onshow;
	widget.onremove = onremove;
}
